/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.ftbsbc.dimensions.kubejs.StoneBlockDataKjs;
import dev.ftb.ftbsbc.dimensions.level.ArchivedDimension;
import dev.ftb.ftbsbc.dimensions.net.CreateDimensionForTeam;
import dev.ftb.ftbsbc.dimensions.screen.StartSelectScreen;
import dev.latvian.mods.kubejs.KubeJS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DimensionsClient {
    public static boolean debugMode = false;
    public static final List<ArchivedDimension> knownDimensions = new ArrayList<ArchivedDimension>();

    @SubscribeEvent
    public static void registerClientCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbstoneblock-client").then(Commands.m_82127_((String)"debug").executes(context -> DimensionsClient.toggleDebug())));
    }

    public static void init() {
        DimensionSpecialEffects.f_108857_.put((Object)new ResourceLocation("ftbsbc", "stoneblock"), (Object)new StoneblockDimensionSpecialEffects());
    }

    public static void exportBiomes(ServerLevel level, Path path, int radius) {
        KubeJS.startupScriptManager.unload();
        KubeJS.startupScriptManager.loadFromDirectory();
        KubeJS.startupScriptManager.load();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        try (NativeImage image = new NativeImage(radius * 2 + 1, radius * 2 + 1, true);){
            for (int x = 0; x <= radius * 2; ++x) {
                for (int z = 0; z <= radius * 2; ++z) {
                    pos.m_122178_(x - radius + Mth.m_14107_((double)player.m_20185_()), 0, z - radius + Mth.m_14107_((double)player.m_20189_()));
                    image.m_84988_(x, z, StoneBlockDataKjs.getColor(level, (BlockPos)pos));
                }
            }
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            image.m_85066_(path);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void openSelectionScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new StartSelectScreen(prebuild -> new CreateDimensionForTeam(prebuild.id).sendToServer()));
    }

    public static int toggleDebug() {
        debugMode = !debugMode;
        return 0;
    }

    public static Set<ResourceKey<Level>> playerLevels(Player player) {
        return ((LocalPlayer)player).f_108617_.m_105151_();
    }

    private static class StoneblockDimensionSpecialEffects
    extends DimensionSpecialEffects {
        public StoneblockDimensionSpecialEffects() {
            super(Float.NaN, false, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        }

        public Vec3 m_5927_(Vec3 arg, float f) {
            return arg.m_82490_(0.15);
        }

        public boolean m_5781_(int i, int j) {
            return false;
        }

        @Nullable
        public float[] m_7518_(float f, float g) {
            return null;
        }
    }
}

